<?php
/**
 * Settings Page
 */

if (!defined('ABSPATH')) {
    exit;
}

$options = isset($b19cojp_ai_bot_chat_options) ? $b19cojp_ai_bot_chat_options : get_option('b19cojp_ai_bot_chat_options', array());

// ライセンス情報を取得
$license_validator = new B19COJP_AI_Bot_Chat_License_Validator();
$license_info = $license_validator->get_license_info();
$is_pro = $license_validator->is_pro_active();

// Google OAuth
$google_oauth = new B19AIBOC_Google_OAuth();
$google_connected = $google_oauth->is_connected();

// Google接続成功メッセージ
if (isset($_GET['google_connected'])) {
    echo '<div class="notice notice-success is-dismissible"><p>Googleアカウントに接続しました。</p></div>';
}
if (isset($_GET['google_error'])) {
    echo '<div class="notice notice-error is-dismissible"><p>Google接続に失敗しました。</p></div>';
}

// Google連携解除処理
if (isset($_POST['google_disconnect']) && check_admin_referer('google_disconnect_action', 'google_disconnect_nonce')) {
    $google_oauth->disconnect();
    $google_connected = false;
    echo '<div class="notice notice-success"><p>Google連携を解除しました。</p></div>';
}

// ライセンスアクション処理
if (isset($_POST['b19_license_action']) && check_admin_referer('b19_license_action', 'b19_license_nonce')) {
    if ($_POST['b19_license_action'] === 'activate' && !empty($_POST['license_key'])) {
        $result = $license_validator->activate_license(sanitize_text_field(wp_unslash($_POST['license_key'])));
        if ($result['success']) {
            $license_info = $license_validator->get_license_info();
            $is_pro = true;
            echo '<div class="notice notice-success"><p>' . esc_html($result['message']) . '</p></div>';
        } else {
            echo '<div class="notice notice-error"><p>' . esc_html($result['message']) . '</p></div>';
        }
    } elseif ($_POST['b19_license_action'] === 'deactivate') {
        $result = $license_validator->deactivate_license();
        $license_info = $license_validator->get_license_info();
        $is_pro = false;
        echo '<div class="notice notice-success"><p>' . esc_html($result['message']) . '</p></div>';
    }
}
?>

<div class="wrap">
    <h1><?php esc_html_e('AI Bot Chat 設定', 'b19-ai-bot-chat'); ?></h1>
    
    <form method="post" action="options.php">
        <?php settings_fields('b19cojp_ai_bot_chat_options'); ?>
        
        <h2><?php esc_html_e('基本設定', 'b19-ai-bot-chat'); ?></h2>
        <table class="form-table">
            <tr>
                <th scope="row"><?php esc_html_e('プラグインの有効化', 'b19-ai-bot-chat'); ?></th>
                <td>
                    <label>
                        <input type="checkbox" name="b19cojp_ai_bot_chat_options[enabled]" value="1" <?php checked(isset($options['enabled']) ? $options['enabled'] : false); ?> />
                        <?php esc_html_e('チャットボットを有効にする', 'b19-ai-bot-chat'); ?>
                    </label>
                </td>
            </tr>
            
            <tr>
                <th scope="row"><?php esc_html_e('OpenAI APIキー', 'b19-ai-bot-chat'); ?></th>
                <td>
                    <input type="password" name="b19cojp_ai_bot_chat_options[api_key]" value="<?php echo esc_attr(isset($options['api_key']) ? $options['api_key'] : ''); ?>" class="regular-text" />
                    <p class="description"><?php esc_html_e('OpenAI APIキーを入力してください', 'b19-ai-bot-chat'); ?></p>
                </td>
            </tr>
            
            <tr>
                <th scope="row"><?php esc_html_e('モデル', 'b19-ai-bot-chat'); ?></th>
                <td>
                    <select name="b19cojp_ai_bot_chat_options[model]">
                        <option value="gpt-4o-mini" <?php selected(isset($options['model']) ? $options['model'] : 'gpt-4o-mini', 'gpt-4o-mini'); ?>><?php esc_html_e('GPT-4o Mini（推奨）', 'b19-ai-bot-chat'); ?></option>
                        <option value="gpt-4o" <?php selected(isset($options['model']) ? $options['model'] : '', 'gpt-4o'); ?>><?php esc_html_e('GPT-4o', 'b19-ai-bot-chat'); ?></option>
                        <option value="gpt-3.5-turbo" <?php selected(isset($options['model']) ? $options['model'] : '', 'gpt-3.5-turbo'); ?>><?php esc_html_e('GPT-3.5 Turbo', 'b19-ai-bot-chat'); ?></option>
                    </select>
                </td>
            </tr>
            
            <tr>
                <th scope="row"><?php esc_html_e('最大トークン数', 'b19-ai-bot-chat'); ?></th>
                <td>
                    <input type="number" name="b19cojp_ai_bot_chat_options[max_tokens]" value="<?php echo esc_attr(isset($options['max_tokens']) ? $options['max_tokens'] : 1000); ?>" min="1" max="4000" />
                </td>
            </tr>
            
            <tr>
                <th scope="row"><?php esc_html_e('温度', 'b19-ai-bot-chat'); ?></th>
                <td>
                    <input type="number" name="b19cojp_ai_bot_chat_options[temperature]" value="<?php echo esc_attr(isset($options['temperature']) ? $options['temperature'] : 0.7); ?>" min="0" max="2" step="0.1" />
                </td>
            </tr>
            
            <tr>
                <th scope="row"><?php esc_html_e('レート制限', 'b19-ai-bot-chat'); ?></th>
                <td>
                    <input type="number" name="b19cojp_ai_bot_chat_options[rate_limit]" value="<?php echo esc_attr(isset($options['rate_limit']) ? $options['rate_limit'] : 10); ?>" min="1" max="100" />
                    <p class="description"><?php esc_html_e('1分間に送信できるメッセージ数', 'b19-ai-bot-chat'); ?></p>
                </td>
            </tr>
            
            <tr>
                <th scope="row"><?php esc_html_e('チャットBOTの名前', 'b19-ai-bot-chat'); ?></th>
                <td>
                    <input type="text" name="b19cojp_ai_bot_chat_options[bot_name]" value="<?php echo esc_attr(isset($options['bot_name']) ? $options['bot_name'] : 'AI Bot Chat'); ?>" class="regular-text" />
                </td>
            </tr>
            
            <tr>
                <th scope="row"><?php esc_html_e('初期メッセージ', 'b19-ai-bot-chat'); ?></th>
                <td>
                    <textarea name="b19cojp_ai_bot_chat_options[initial_message]" rows="2" cols="50" class="large-text"><?php echo esc_textarea(isset($options['initial_message']) ? $options['initial_message'] : 'こんにちは！何かお手伝いできることはありますか？'); ?></textarea>
                </td>
            </tr>
        </table>
        
        <h2><?php esc_html_e('会社・お店の情報', 'b19-ai-bot-chat'); ?></h2>
        <table class="form-table">
            <tr>
                <th scope="row"><?php esc_html_e('会社・お店名', 'b19-ai-bot-chat'); ?></th>
                <td>
                    <input type="text" name="b19cojp_ai_bot_chat_options[company_name]" value="<?php echo esc_attr(isset($options['company_name']) ? $options['company_name'] : ''); ?>" class="regular-text" />
                </td>
            </tr>
            
            <tr>
                <th scope="row"><?php esc_html_e('事業内容・特徴', 'b19-ai-bot-chat'); ?></th>
                <td>
                    <textarea name="b19cojp_ai_bot_chat_options[company_description]" rows="4" cols="50" class="large-text"><?php echo esc_textarea(isset($options['company_description']) ? $options['company_description'] : ''); ?></textarea>
                </td>
            </tr>
            
            <tr>
                <th scope="row"><?php esc_html_e('営業時間', 'b19-ai-bot-chat'); ?></th>
                <td>
                    <input type="text" name="b19cojp_ai_bot_chat_options[business_hours]" value="<?php echo esc_attr(isset($options['business_hours']) ? $options['business_hours'] : ''); ?>" class="regular-text" />
                </td>
            </tr>
            
            <tr>
                <th scope="row"><?php esc_html_e('連絡先', 'b19-ai-bot-chat'); ?></th>
                <td>
                    <input type="text" name="b19cojp_ai_bot_chat_options[contact_info]" value="<?php echo esc_attr(isset($options['contact_info']) ? $options['contact_info'] : ''); ?>" class="regular-text" />
                </td>
            </tr>
            
            <tr>
                <th scope="row"><?php esc_html_e('カスタムプロンプト', 'b19-ai-bot-chat'); ?></th>
                <td>
                    <textarea name="b19cojp_ai_bot_chat_options[custom_prompt]" rows="4" cols="50" class="large-text"><?php echo esc_textarea(isset($options['custom_prompt']) ? $options['custom_prompt'] : ''); ?></textarea>
                    <p class="description"><?php esc_html_e('チャットボットの性格や回答スタイルをカスタマイズできます', 'b19-ai-bot-chat'); ?></p>
                </td>
            </tr>
        </table>
        
        <?php submit_button(); ?>
    </form>
    
    <hr style="margin: 30px 0;">
    
    <!-- Pro版ライセンス -->
    <h2><?php esc_html_e('Pro版', 'b19-ai-bot-chat'); ?></h2>
    
    <?php if ($is_pro): ?>
        <div class="card" style="max-width: 600px; background: #d4edda; border-left: 4px solid #28a745;">
            <p><strong>Pro版がアクティブです</strong></p>
            <p>ライセンス: <?php echo esc_html(substr($license_info['license_key'], 0, 15) . '...'); ?></p>
            <form method="post" style="margin-top: 10px;">
                <?php wp_nonce_field('b19_license_action', 'b19_license_nonce'); ?>
                <input type="hidden" name="b19_license_action" value="deactivate" />
                <button type="submit" class="button"><?php esc_html_e('ライセンスを解除', 'b19-ai-bot-chat'); ?></button>
            </form>
        </div>
        
        <!-- Pro版機能：Googleスプレッドシート連携 -->
        <h3 style="margin-top: 30px;"><?php esc_html_e('Googleスプレッドシート連携（Pro版機能）', 'b19-ai-bot-chat'); ?></h3>
        
        <div class="card" style="max-width: 700px;">
            <?php if ($google_connected): ?>
                <!-- 接続済み -->
                <div style="background: #e8f5e9; padding: 15px; border-radius: 4px; margin-bottom: 20px;">
                    <p style="margin: 0;"><strong>Googleアカウント接続済み</strong></p>
                    <?php if (!empty($options['google_user_email'])): ?>
                        <p style="margin: 5px 0 0 0;"><?php echo esc_html($options['google_user_email']); ?></p>
                    <?php endif; ?>
                </div>
                
                <form method="post" action="options.php">
                    <?php settings_fields('b19cojp_ai_bot_chat_options'); ?>
                    
                    <!-- 隠しフィールドで既存のGoogle認証情報を保持 -->
                    <input type="hidden" name="b19cojp_ai_bot_chat_options[google_access_token]" value="<?php echo esc_attr($options['google_access_token'] ?? ''); ?>" />
                    <input type="hidden" name="b19cojp_ai_bot_chat_options[google_refresh_token]" value="<?php echo esc_attr($options['google_refresh_token'] ?? ''); ?>" />
                    <input type="hidden" name="b19cojp_ai_bot_chat_options[google_token_expires]" value="<?php echo esc_attr($options['google_token_expires'] ?? ''); ?>" />
                    <input type="hidden" name="b19cojp_ai_bot_chat_options[google_user_email]" value="<?php echo esc_attr($options['google_user_email'] ?? ''); ?>" />
                    
                    <table class="form-table">
                        <tr>
                            <th scope="row"><?php esc_html_e('スプレッドシートURL', 'b19-ai-bot-chat'); ?></th>
                            <td>
                                <input type="url" name="b19cojp_ai_bot_chat_options[spreadsheet_url]" value="<?php echo esc_attr(isset($options['spreadsheet_url']) ? $options['spreadsheet_url'] : ''); ?>" class="large-text" placeholder="https://docs.google.com/spreadsheets/d/xxxxx/edit" />
                                <p class="description">FAQデータが入っているスプレッドシートのURLを入力してください</p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row"><?php esc_html_e('シート名', 'b19-ai-bot-chat'); ?></th>
                            <td>
                                <input type="text" name="b19cojp_ai_bot_chat_options[sheet_name]" value="<?php echo esc_attr(isset($options['sheet_name']) ? $options['sheet_name'] : 'FAQ'); ?>" class="regular-text" />
                                <p class="description">デフォルト: FAQ（1列目に「質問」、2列目に「回答」を入力）</p>
                            </td>
                        </tr>
                    </table>
                    <?php submit_button(__('スプレッドシート設定を保存', 'b19-ai-bot-chat')); ?>
                </form>
                
                <hr style="margin: 20px 0;">
                
                <form method="post">
                    <?php wp_nonce_field('google_disconnect_action', 'google_disconnect_nonce'); ?>
                    <input type="hidden" name="google_disconnect" value="1" />
                    <button type="submit" class="button" onclick="return confirm('Google連携を解除しますか？');">Google連携を解除</button>
                </form>
                
            <?php else: ?>
                <!-- 未接続 -->
                <p>Googleアカウントと連携すると、スプレッドシートのFAQデータをチャットボットに読み込めます。</p>
                
                <p style="margin: 20px 0;">
                    <a href="<?php echo esc_url($google_oauth->get_auth_url()); ?>" class="button button-primary button-hero" style="display: inline-flex; align-items: center; gap: 10px;">
                        <svg width="18" height="18" viewBox="0 0 24 24"><path fill="#fff" d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z"/><path fill="#fff" d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z"/><path fill="#fff" d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z"/><path fill="#fff" d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z"/></svg>
                        Googleでログイン
                    </a>
                </p>
                
                <div style="background: #fff3cd; padding: 15px; border-radius: 4px; margin-top: 20px;">
                    <p style="margin: 0 0 10px 0;"><strong>初回設定が必要です</strong></p>
                    <p style="margin: 0;">Google Cloud ConsoleでOAuth認証情報を設定してください。詳しくは<a href="https://b19.co.jp/ai-bot-chat-pro/setup/" target="_blank">セットアップガイド</a>をご覧ください。</p>
                </div>
                
                <form method="post" action="options.php" style="margin-top: 20px;">
                    <?php settings_fields('b19cojp_ai_bot_chat_options'); ?>
                    <table class="form-table">
                        <tr>
                            <th scope="row">Google Client ID</th>
                            <td>
                                <input type="text" name="b19cojp_ai_bot_chat_options[google_client_id]" value="<?php echo esc_attr(isset($options['google_client_id']) ? $options['google_client_id'] : ''); ?>" class="large-text" />
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">Google Client Secret</th>
                            <td>
                                <input type="password" name="b19cojp_ai_bot_chat_options[google_client_secret]" value="<?php echo esc_attr(isset($options['google_client_secret']) ? $options['google_client_secret'] : ''); ?>" class="large-text" />
                            </td>
                        </tr>
                    </table>
                    <?php submit_button(__('OAuth設定を保存', 'b19-ai-bot-chat')); ?>
                </form>
            <?php endif; ?>
        </div>
        
    <?php else: ?>
        <div class="card" style="max-width: 600px;">
            <p><?php esc_html_e('Pro版ではGoogleスプレッドシート連携機能が利用できます。', 'b19-ai-bot-chat'); ?></p>
            <ul style="margin-left: 20px;">
                <li>Googleアカウントで簡単ログイン</li>
                <li>スプレッドシートからFAQを自動読み込み</li>
                <li>選択したスプレッドシートのみアクセス（安全）</li>
            </ul>
            <p><a href="https://b19.co.jp/ai-bot-chat-pro/" target="_blank" class="button button-primary">Pro版を購入する（月額980円）</a></p>
            
            <hr style="margin: 20px 0;">
            
            <p><strong><?php esc_html_e('ライセンスキーをお持ちの方', 'b19-ai-bot-chat'); ?></strong></p>
            <form method="post">
                <?php wp_nonce_field('b19_license_action', 'b19_license_nonce'); ?>
                <input type="hidden" name="b19_license_action" value="activate" />
                <input type="text" name="license_key" value="" class="regular-text" placeholder="AIBOT-XXXX-XXXX-XXXX-XXXX" style="margin-right: 10px;" />
                <button type="submit" class="button button-primary"><?php esc_html_e('アクティベート', 'b19-ai-bot-chat'); ?></button>
            </form>
        </div>
    <?php endif; ?>
    
    <hr style="margin: 30px 0;">
    
    <div class="card" style="max-width: 600px;">
        <h3 style="margin-top: 0;"><?php esc_html_e('使用方法', 'b19-ai-bot-chat'); ?></h3>
        <p><?php esc_html_e('チャットボットは自動的にサイトに表示されます。', 'b19-ai-bot-chat'); ?></p>
        <p><?php esc_html_e('ショートコード:', 'b19-ai-bot-chat'); ?> <code>[b19cojp_ai_bot_chat]</code></p>
    </div>
</div>
