<?php
/**
 * Rate Limit Class
 */

if (!defined('ABSPATH')) {
    exit;
}

class B19COJP_AI_Bot_Chat_Rate_Limit {
    
    private $limit;
    private $window;
    
    public function __construct() {
        $options = get_option('b19cojp_ai_bot_chat_options', array());
        $this->limit = isset($options['rate_limit']) ? $options['rate_limit'] : 10;
        $this->window = 60; // 1分間
    }
    
    public function check_limit() {
        $user_ip = $this->get_user_ip();
        $key = 'b19cojp_chatbot_rate_limit_' . $user_ip;
        
        $current_count = get_transient($key);
        
        if ($current_count === false) {
            set_transient($key, 1, $this->window);
            return true;
        }
        
        if ($current_count >= $this->limit) {
            return false;
        }
        
        set_transient($key, $current_count + 1, $this->window);
        return true;
    }
    
    public function increment() {
        $user_ip = $this->get_user_ip();
        $key = 'b19cojp_chatbot_rate_limit_' . $user_ip;
        
        $current_count = get_transient($key);
        
        if ($current_count === false) {
            set_transient($key, 1, $this->window);
        } else {
            set_transient($key, $current_count + 1, $this->window);
        }
    }
    
    private function get_user_ip() {
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            return sanitize_text_field(wp_unslash($_SERVER['HTTP_CLIENT_IP']));
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            return sanitize_text_field(wp_unslash($_SERVER['HTTP_X_FORWARDED_FOR']));
        } elseif (isset($_SERVER['REMOTE_ADDR'])) {
            return sanitize_text_field(wp_unslash($_SERVER['REMOTE_ADDR']));
        } else {
            return '0.0.0.0';
        }
    }
}
