<?php
// 直接アクセスを防ぐ
if (!defined('ABSPATH')) {
    exit;
}

// プラグイン設定を取得
// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Variables used only within template scope
$b19cojp_options = get_option('b19cojp_ai_bot_chat_options', array());
$b19cojp_bot_name = isset($b19cojp_options['bot_name']) ? $b19cojp_options['bot_name'] : 'AI Bot Chat';
$b19cojp_initial_message = isset($b19cojp_options['initial_message']) ? $b19cojp_options['initial_message'] : __('Hello! How can I help you today?', 'b19-ai-bot-chat');
$b19cojp_rate_limit = isset($b19cojp_options['rate_limit']) ? $b19cojp_options['rate_limit'] : 10;
// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
?>

<div class="ai-bot-chat-b19-interface" data-rate-limit="<?php echo esc_attr($b19cojp_rate_limit); ?>">
    <div class="ai-bot-chat-b19-header">
        <div class="ai-bot-chat-b19-title">
            <i class="ai-bot-chat-b19-icon">🤖</i>
            <span class="ai-bot-chat-b19-title-text"><?php echo esc_html($b19cojp_bot_name); ?></span>
        </div>
        <div class="ai-bot-chat-b19-controls">
            <button class="ai-bot-chat-b19-toggle-btn" id="ai-bot-chat-b19-toggle-btn" title="<?php esc_attr_e('Maximize/Minimize', 'b19-ai-bot-chat'); ?>">
                <span class="ai-bot-chat-b19-toggle-icon">−</span>
            </button>
        </div>
    </div>
    
                <div class="ai-bot-chat-b19-messages" id="ai-bot-chat-b19-messages">
                    <div class="ai-bot-chat-b19-message ai-bot-chat-b19-bot-message">
                        <div class="ai-bot-chat-b19-message-content">
                            <?php if (empty($b19cojp_options['api_key'])): ?>
                                <p>⚠️ <?php esc_html_e('Chatbot configuration is not complete.', 'b19-ai-bot-chat'); ?></p>
                                <p><strong><?php esc_html_e('For administrators:', 'b19-ai-bot-chat'); ?></strong></p>
                                <ol style="text-align: left; margin: 10px 0; padding-left: 20px;">
                                    <li><?php esc_html_e('Log in to WordPress admin', 'b19-ai-bot-chat'); ?></li>
                                    <li><?php esc_html_e('Plugins → B19 AI Bot Chat → Settings', 'b19-ai-bot-chat'); ?></li>
                                    <li><?php esc_html_e('Please set up OpenAI API key', 'b19-ai-bot-chat'); ?></li>
                                </ol>
                                <p><a href="https://platform.openai.com/api-keys" target="_blank" style="color: #007cba;"><?php esc_html_e('How to get API key', 'b19-ai-bot-chat'); ?></a></p>
                            <?php else: ?>
                                <p><?php echo esc_html($b19cojp_initial_message); ?></p>
                            <?php endif; ?>
                        </div>
                        <div class="ai-bot-chat-b19-message-time"><?php echo esc_html(current_time('H:i')); ?></div>
                    </div>
                </div>
    
    <div class="ai-bot-chat-b19-input-area">
        <div class="ai-bot-chat-new-input-wrapper">
            <textarea 
                id="ai-bot-chat-new-input" 
                class="ai-bot-chat-new-input"
                placeholder="<?php echo esc_attr(empty($b19cojp_options['api_key']) ? __('Please configure API key', 'b19-ai-bot-chat') : __('Please enter a message...', 'b19-ai-bot-chat')); ?>"
                rows="1"
                maxlength="1000"
                data-max-length="1000"
                data-min-length="1"
                <?php echo empty($b19cojp_options['api_key']) ? 'disabled' : ''; ?>
            ></textarea>
            <button id="ai-bot-chat-new-send-button" class="ai-bot-chat-new-send-button" <?php echo empty($b19cojp_options['api_key']) ? 'disabled title="' . esc_attr__('API key not configured', 'b19-ai-bot-chat') . '"' : 'disabled'; ?>>
                <span class="ai-bot-chat-new-send-icon">📤</span>
            </button>
        </div>
        
        <!-- 文字数カウンター -->
        <div class="ai-bot-chat-b19-character-counter-wrapper">
            <div class="ai-bot-chat-b19-character-counter" id="ai-bot-chat-b19-character-counter">0/1000 <?php esc_html_e('characters', 'b19-ai-bot-chat'); ?></div>
            <div class="ai-bot-chat-b19-input-status" id="ai-bot-chat-b19-input-status"></div>
        </div>
        
        <div class="ai-bot-chat-b19-info">
            <div class="ai-bot-chat-b19-rate-limit-info">
                <span class="ai-bot-chat-b19-rate-limit"><?php 
                /* translators: %d is the number of remaining requests */
                printf(esc_html__('残りリクエスト: %d回/分', 'b19-ai-bot-chat'), esc_html($b19cojp_rate_limit)); ?></span>
            </div>
        </div>
        
    </div>
    
</div>


