/**
 * B19 Post Gallery - Gutenberg Block
 */

(function(blocks, element, components, editor) {
    var el = element.createElement;
    var Fragment = element.Fragment;
    var InspectorControls = editor.InspectorControls;
    var PanelBody = components.PanelBody;
    var SelectControl = components.SelectControl;
    var RangeControl = components.RangeControl;
    var ToggleControl = components.ToggleControl;
    var Placeholder = components.Placeholder;
    var Spinner = components.Spinner;

    blocks.registerBlockType('b19/post-gallery', {
        title: 'B19 Post Gallery',
        description: '美しい変則グリッドレイアウトで投稿を表示',
        icon: 'grid-view',
        category: 'widgets',
        keywords: ['gallery', 'grid', 'posts', 'グリッド', '投稿'],
        
        attributes: {
            layout: {
                type: 'string',
                default: 'grid-6-4-right'
            },
            category: {
                type: 'string',
                default: ''
            },
            postsPerPage: {
                type: 'number',
                default: 5
            },
            showDate: {
                type: 'boolean',
                default: true
            },
            showAuthor: {
                type: 'boolean',
                default: false
            },
            showExcerpt: {
                type: 'boolean',
                default: true
            },
            showVideoThumbnail: {
                type: 'boolean',
                default: true
            }
        },

        edit: function(props) {
            var attributes = props.attributes;

            return el(
                Fragment,
                {},
                el(
                    InspectorControls,
                    {},
                    el(
                        PanelBody,
                        { title: 'レイアウト設定', initialOpen: true },
                        el(SelectControl, {
                            label: 'レイアウト',
                            value: attributes.layout,
                            options: [
                                { label: '6:4 左大右小', value: 'grid-6-4-right' },
                                { label: '標準グリッド', value: 'grid-standard' },
                                { label: 'リスト表示', value: 'grid-list' }
                            ],
                            onChange: function(value) {
                                props.setAttributes({ layout: value });
                            }
                        }),
                        el(RangeControl, {
                            label: '表示件数',
                            value: attributes.postsPerPage,
                            onChange: function(value) {
                                props.setAttributes({ postsPerPage: value });
                            },
                            min: 1,
                            max: 20
                        })
                    ),
                    el(
                        PanelBody,
                        { title: '表示オプション', initialOpen: false },
                        el(ToggleControl, {
                            label: '日付を表示',
                            checked: attributes.showDate,
                            onChange: function(value) {
                                props.setAttributes({ showDate: value });
                            }
                        }),
                        el(ToggleControl, {
                            label: '著者を表示',
                            checked: attributes.showAuthor,
                            onChange: function(value) {
                                props.setAttributes({ showAuthor: value });
                            }
                        }),
                        el(ToggleControl, {
                            label: '抜粋を表示',
                            checked: attributes.showExcerpt,
                            onChange: function(value) {
                                props.setAttributes({ showExcerpt: value });
                            }
                        }),
                        el(ToggleControl, {
                            label: '動画サムネイルを表示',
                            checked: attributes.showVideoThumbnail,
                            onChange: function(value) {
                                props.setAttributes({ showVideoThumbnail: value });
                            }
                        })
                    )
                ),
                el(
                    'div',
                    { className: 'b19-block-preview' },
                    el(
                        Placeholder,
                        {
                            icon: 'grid-view',
                            label: 'B19 Post Gallery'
                        },
                        el('p', {}, 'レイアウト: ' + attributes.layout),
                        el('p', {}, '表示件数: ' + attributes.postsPerPage + '件'),
                        el('small', {}, 'サイドパネルで設定を変更できます')
                    )
                )
            );
        },

        save: function() {
            // サーバーサイドレンダリング
            return null;
        }
    });

})(
    window.wp.blocks,
    window.wp.element,
    window.wp.components,
    window.wp.blockEditor || window.wp.editor
);
