/**
 * B19 Post Gallery - Frontend Script
 */

(function($) {
    'use strict';

    $(document).ready(function() {
        // ギャラリーの初期化
        $('.b19-post-gallery').each(function() {
            initGallery($(this));
        });
    });

    function initGallery($gallery) {
        // 画像の遅延読み込み対応
        if ('IntersectionObserver' in window) {
            var imageObserver = new IntersectionObserver(function(entries, observer) {
                entries.forEach(function(entry) {
                    if (entry.isIntersecting) {
                        var $img = $(entry.target);
                        if ($img.data('src')) {
                            $img.attr('src', $img.data('src'));
                            $img.removeAttr('data-src');
                        }
                        observer.unobserve(entry.target);
                    }
                });
            });

            $gallery.find('img[data-src]').each(function() {
                imageObserver.observe(this);
            });
        }

        // アクセシビリティ: キーボードナビゲーション
        $gallery.find('.b19-post-link').on('keydown', function(e) {
            if (e.key === 'Enter' || e.key === ' ') {
                e.preventDefault();
                window.location.href = $(this).attr('href');
            }
        });
    }

})(jQuery);
