<?php
/**
 * Plugin Name: B19 Post Gallery
 * Plugin URI: https://b19.co.jp/plugins/post-gallery
 * Description: 美しい変則グリッドレイアウトで投稿を表示。動画サムネイル対応、日本語ネイティブUI。
 * Version: 1.0.0
 * Author: B19 Inc.
 * Author URI: https://b19.co.jp
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: b19-post-gallery
 * Domain Path: /languages
 * Requires at least: 5.0
 * Requires PHP: 7.4
 */

// 直接アクセス禁止
if (!defined('ABSPATH')) {
    exit;
}

// プラグイン定数
define('B19_POST_GALLERY_VERSION', '1.0.0');
define('B19_POST_GALLERY_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('B19_POST_GALLERY_PLUGIN_URL', plugin_dir_url(__FILE__));
define('B19_POST_GALLERY_PLUGIN_BASENAME', plugin_basename(__FILE__));

// プレミアム版フラグ（将来的にライセンス認証で切り替え）
define('B19_POST_GALLERY_IS_PRO', false);

/**
 * メインクラス
 */
class B19_Post_Gallery {
    
    private static $instance = null;
    
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        $this->includes();
        $this->init_hooks();
    }
    
    private function includes() {
        require_once B19_POST_GALLERY_PLUGIN_DIR . 'includes/class-shortcode.php';
        require_once B19_POST_GALLERY_PLUGIN_DIR . 'includes/class-admin.php';
        require_once B19_POST_GALLERY_PLUGIN_DIR . 'includes/class-video-thumbnail.php';
    }
    
    private function init_hooks() {
        add_action('init', array($this, 'load_textdomain'));
        add_action('wp_enqueue_scripts', array($this, 'enqueue_frontend_assets'));
        add_action('admin_enqueue_scripts', array($this, 'enqueue_admin_assets'));
        
        // ショートコード登録
        add_shortcode('b19_gallery', array('B19_Post_Gallery_Shortcode', 'render'));
        
        // Gutenbergブロック登録
        add_action('init', array($this, 'register_block'));
    }
    
    public function load_textdomain() {
        load_plugin_textdomain(
            'b19-post-gallery',
            false,
            dirname(B19_POST_GALLERY_PLUGIN_BASENAME) . '/languages/'
        );
    }
    
    public function enqueue_frontend_assets() {
        wp_enqueue_style(
            'b19-post-gallery',
            B19_POST_GALLERY_PLUGIN_URL . 'assets/css/style.css',
            array(),
            B19_POST_GALLERY_VERSION
        );
        
        wp_enqueue_script(
            'b19-post-gallery',
            B19_POST_GALLERY_PLUGIN_URL . 'assets/js/script.js',
            array('jquery'),
            B19_POST_GALLERY_VERSION,
            true
        );
    }
    
    public function enqueue_admin_assets($hook) {
        if (strpos($hook, 'b19-post-gallery') === false) {
            return;
        }
        
        wp_enqueue_style(
            'b19-post-gallery-admin',
            B19_POST_GALLERY_PLUGIN_URL . 'assets/css/admin.css',
            array(),
            B19_POST_GALLERY_VERSION
        );
        
        wp_enqueue_script(
            'b19-post-gallery-admin',
            B19_POST_GALLERY_PLUGIN_URL . 'assets/js/admin.js',
            array('jquery'),
            B19_POST_GALLERY_VERSION,
            true
        );
    }
    
    public function register_block() {
        if (!function_exists('register_block_type')) {
            return;
        }
        
        wp_register_script(
            'b19-post-gallery-block',
            B19_POST_GALLERY_PLUGIN_URL . 'assets/js/block.js',
            array('wp-blocks', 'wp-element', 'wp-editor', 'wp-components'),
            B19_POST_GALLERY_VERSION
        );
        
        register_block_type('b19/post-gallery', array(
            'editor_script' => 'b19-post-gallery-block',
            'render_callback' => array('B19_Post_Gallery_Shortcode', 'render_block'),
        ));
    }
}

// プラグイン初期化
function b19_post_gallery_init() {
    return B19_Post_Gallery::get_instance();
}
add_action('plugins_loaded', 'b19_post_gallery_init');

// アクティベーション
register_activation_hook(__FILE__, function() {
    // デフォルトオプション設定
    $defaults = array(
        'default_layout' => 'grid-6-4-right',
        'show_pro_notice' => true,
    );
    add_option('b19_post_gallery_options', $defaults);
});

// アンインストール
register_uninstall_hook(__FILE__, 'b19_post_gallery_uninstall');
function b19_post_gallery_uninstall() {
    delete_option('b19_post_gallery_options');
}
